#include <avr/interrupt.h>
#include <avr/io.h>

#include "global.h"
#include "reset.h"



void init_ports_timers(void) {

	PORTC=0x00;
	DDRC=0xff;
	
	PORTD=0x02;
	DDRD=0xf3;
	
	PORTB=0x00;
	DDRB=0x00;

}


inline void power_management(uint8_t mode) {
	SMCR=(mode<<1);
	SMCR|=(1<<SE);
	asm volatile ("sleep");
}
