#include <avr/io.h>
#include <avr/interrupt.h>
#include "global.h"
#include "reset.h"
#include <util/delay.h>
#include <avr/sleep.h>



volatile uint8_t power=1;


inline void set_sensorpower(uint8_t on) {
	if( on)
		PORTD|=(1<<PD4);
	else
		PORTD&=~(1<<PD4);
}

inline void led_on(void) {
	PORTC=0x00; 
}
inline void led_off(void) {
	PORTC=0x01;
}


void timer_on(void) {
	PRR=(1<<PRTWI)|(1<<PRSPI)|(0<<PRTIM0)|(1<<PRTIM1)|(1<<PRTIM2)|(1<<PRUSART0)|(1<<PRADC);
	
	TCCR0A=0x00;
	TCCR0B=0x05;
	TIMSK0=0x01;
	TCNT0=0;
}

void timer_off(void) {
	TCCR0A=0x00;
	TCCR0B=0x00;
	TIMSK0=0x00;
	PRR=(1<<PRTWI)|(1<<PRSPI)|(1<<PRTIM0)|(1<<PRTIM1)|(1<<PRTIM2)|(1<<PRUSART0)|(1<<PRADC);
}


inline void power_on(void) {
	// interrupt for light sensor off until the voltage is stable and sensor power on
	set_sensorpower(1);

	_delay_ms(100);

	
	// set low status for button
	// set rising edge for flash
	EIFR=0x03;
	EICRA=0x0e;
	EIMSK=0x03;

	timer_on();
	EIFR=0x03;
	sei();
	
}

void power_off(void) {

	set_sensorpower(0);
	

	// clock select minimum
//	CLKPR=0x80;
//	CLKPR=0x08;

	_delay_ms(100);
	EICRA=0x00;
	EIMSK=0x01;
	EIFR=0x03;
	sei();
	
	power_management(POWER_DOWN);

}


ISR(INT0_vect) {  // button

	cli();
	timer_off();
	led_on();
	while(!(PIND&0x04));
	led_off();

	if(power) {
		power=0;
		power_off();
	}
	else { // wakeup
		power=1;
		power_on();
	}
	EIFR=0x03;
	sei();
}

ISR(INT1_vect) {  // flash
	
	PORTD&=~(1<<PD5);
	_delay_ms(15);
	PORTD|=(1<<PD5);
	
}


ISR(TIMER0_OVF_vect) {

	static uint8_t led=0;
	
	led++;
	
	if(led<=25)
		led_off();
	else {
		led_on();
		led=0;
	}

}


int main(void){

	init_ports_timers();
	
	// clock select 8MHz
	CLKPR=0x80;
	CLKPR=0;

	power=1;
	power_on();
	
	while(1) {
		power_management(IDLE);
    }
    return(0);
}
